SELECT tsystem.function__drop_by_regex( 'abk_austerm', 'tplanterm', _commit => true );
CREATE OR REPLACE FUNCTION tplanterm.abk_austerm( _abk_ix integer, _resource_id_main_fix__Reset boolean DEFAULT true ) RETURNS VOID AS $$ -- scheduling.abk__termination_clear
  BEGIN
    -- Flag setzen, damit der AB2-Trigger nicht versucht, die Termine in die ABK zu schreiben.
    PERFORM execution_flag__aquire( _flagname => 'inTerminierung' );

    -- remove from new termination algo
    PERFORM scheduling.abk__termination_clear( _abk_ix, _resource_id_main_fix__Reset => _resource_id_main_fix__Reset ); -- Rests ab2_wkstplan!

    -- Die Übergeordneten nicht entterminieren. Beim einzelnen Terminieren eines Einzelteiles haben sonst die Kopfartikel alle keinen Termin mehr.
    UPDATE ab2 SET a2_at = NULL, a2_et = NULL, a2_interm = false WHERE a2_ab_ix IN ( _abk_ix ) AND NOT a2_buch AND a2_interm;
    UPDATE abk SET ab_at = NULL, ab_et = NULL, ab_inplantaf = false WHERE ab_ix IN ( _abk_ix ) AND NOT ab_buch AND ab_inplantaf;

    -- folgendes ist eigentlich nicht mehr nötig, da automatisch durch abk__a_iud => auftg und darin auch abk__ldsdok__term_set
    UPDATE ldsdok SET ld_term = IFTHEN(ld_interncreate, NULL, ld_term), ld_terml = NULL WHERE ld_abk IN ( _abk_ix ) AND NOT ld_done;
    UPDATE auftg SET ag_kdatum = NULL, ag_ldatum = NULL WHERE ag_parentabk IN ( _abk_ix ) AND NOT ag_done AND ag_astat = 'I';
    UPDATE auftg SET ag_kdatum = NULL, ag_ldatum = NULL WHERE ag_mainabk   IN ( _abk_ix ) AND NOT ag_done AND ag_astat = 'I';

    -- Flag setzen, damit der AB2-Trigger nicht versucht, die Termine in die ABK zu schreiben.
    PERFORM execution_flag__release( _flagname => 'inTerminierung' );

  END $$ LANGUAGE plpgsql;